//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FileCompareForm1.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TFileCompareForm *FileCompareForm;
//---------------------------------------------------------------------------
__fastcall TFileCompareForm::TFileCompareForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFileCompareForm::Browse1Click(TObject *Sender)
{
    TOpenDialog *OpenDialog = new TOpenDialog(this);
	OpenDialog->Filter = "All files (*.*)|*.*";
	if(OpenDialog->Execute())
    	FileName1->Text = OpenDialog->FileName;
	delete OpenDialog;
}
//---------------------------------------------------------------------------
void __fastcall TFileCompareForm::Browse2Click(TObject *Sender)
{
    TOpenDialog *OpenDialog = new TOpenDialog(this);
	OpenDialog->Filter = "All files (*.*)|*.*";
	if(OpenDialog->Execute())
    	FileName2->Text = OpenDialog->FileName;
	delete OpenDialog;
}
//---------------------------------------------------------------------------
void __fastcall TFileCompareForm::FormCreate(TObject *Sender)
{
	FileName1->Text = FileName2->Text = "";
    ResultsListView->Items->Clear();
    ResultsCaption->Caption = "Results";
	CompareButton->Caption = "Compare";
    CancelPushed = false;
}
//---------------------------------------------------------------------------
void __fastcall TFileCompareForm::CompareButtonClick(TObject *Sender)
{
if(CompareButton->Caption == "Compare")
{
	FILE *file1, *file2;
	int test, i, j;
    unsigned long pos, length1, length2, k = 0;
   	char messagebuf[30];

    CancelPushed = false;

    if(FileName1->Text == FileName2->Text)
	{
    	Application->MessageBox("Please select two different files.", "Error", MB_OK + MB_ICONERROR);
		return;
	}

	file1 = fopen(FileName1->Text.c_str(), "rb");
	if(!file1)
    {
		Application->MessageBox("Unable to open first file. Please select a valid path/filename.", "Error", MB_OK + MB_ICONERROR);
		return;
    }

	file2 = fopen(FileName2->Text.c_str(), "rb");
	if(!file2)
   	{
		Application->MessageBox("Unable to open second file. Please select a valid path/filename.", "Error", MB_OK + MB_ICONERROR);
		return;
    }

	fseek(file1, 0, SEEK_END);
	length1 = ftell(file1);
    fseek(file1, 0, SEEK_SET);

    fseek(file2, 0, SEEK_END);
	length2 = ftell(file2);
    fseek(file2, 0, SEEK_SET);

    if(length1 != length2)
    {
		test = Application->MessageBox("Selected files are not the same size. Compare anyway?", "Confirmation", MB_YESNO + MB_ICONQUESTION);
		if(test == IDNO)
		{
         	fclose(file1);
            fclose(file2);
			return;
        }
    }

    ResultsListView->Items->Clear();
    CompareButton->Caption = "Stop";
    ResultsCaption->Caption = "Comparing, please wait...";

    while(!feof(file1) && !feof(file2))
    {
    	Application->ProcessMessages();

        if(CancelPushed)
		{
            fclose(file1);
            fclose(file2);
			CompareButton->Caption = "Compare";
			ResultsCaption->Caption = "Results";
			return;
        }

		i = fgetc(file1);
        j = fgetc(file2);

       	if(i != j)
        {
			if(!feof(file1) && !feof(file2))
            {
				ResultsListView->Items->Add();

                pos = ftell(file1) - 1;
                sprintf(messagebuf, "%lu", pos);
                ResultsListView->Items->Item[k]->Caption = messagebuf;

                sprintf(messagebuf, "%Xh", pos);
                ResultsListView->Items->Item[k]->SubItems->Add(messagebuf);

                sprintf(messagebuf, "%0.2X", i);
				ResultsListView->Items->Item[k]->SubItems->Add(messagebuf);

                sprintf(messagebuf, "%0.2X", j);
				ResultsListView->Items->Item[k]->SubItems->Add(messagebuf);

                k++;
            }
        }
    }

   	fclose(file1);
    fclose(file2);

    CompareButton->Caption = "Compare";
	ResultsCaption->Caption = "Results";

    if(k == 0)
    	Application->MessageBox("No differences encountered.", "Results", MB_OK + MB_ICONINFORMATION);
	else if(k == 1)
		Application->MessageBox("1 difference encountered.", "Results", MB_OK + MB_ICONINFORMATION);
    else
    {
        sprintf(messagebuf, "%lu differences encountered.", k);
		Application->MessageBox(messagebuf, "Results", MB_OK + MB_ICONINFORMATION);
    }
}
else
	CancelPushed = true;
}
//---------------------------------------------------------------------------
void __fastcall TFileCompareForm::CancelButtonClick(TObject *Sender)
{
	CancelPushed = true;
	FileCompareForm->Hide();    	
}
//---------------------------------------------------------------------------
